# Intuition
<!-- Describe your first thoughts on how to solve this problem. -->
A simple use of hashmap.


# Approach
<!-- Describe your approach to solving the problem. -->
Create a hashmap which will store numbers with their respective series possible till now, and for each numbers check if their previous elements were present in array or not, if yes then increse their count, otherwise let it be 1.

Let me explain by a example :  a = [1,5,7,8,5,3,4,2,1], difference = -2
Let max store the maximum length and initially its value is 0.

Star with first element : 1
As ( 1 - (-2 ) ) isn't present in hashmap ( since it is the first element in our hashmap), so its length ( 0 + 1) = 1 
Included in hashmap : (1, 1)
As 1 > max : max = 1

Second element : 5
As ( 5 - (-2) ) isn't present in hashmap, so its length = ( 0 + 1) = 1 
Included in hashmap : (5, 1)
As 1 isn't greater than max, so no change in max

Third element : 7
As ( 7 - (-2) ) isn't present in hashmap, so its length = ( 0 + 1) = 1 
Included in hashmap : (7, 1)
As 1 isn't greater than max, so no change in max

Fourth element : 8
As ( 8 - (-2) ) isn't present in hashmap, so its length = ( 0 + 1) = 1 
Included in hashmap : (8, 1)
As 1 isn't greater than max, so no change in max

Fifth element : 5
As ( 5 - (-2) ) = (7) is present in hashmap, so its length = ( length(7) + 1) = ( 1 + 1) = 2
Included in hashmap : (5, 2)
As 2 > max : max = 2

Sixth element : 3
As ( 3 - (-2) ) = (5) is present in hashmap, so its length = ( length(5) + 1 ) = ( 2 + 1) = 3
Included in hashmap : (3, 3)
As 3 > max : max = 3

Seventh element : 4
As ( 4 - (-2) ) isn't present in hashmap, so its length = ( 0 + 1) = 1 
Included in hashmap : (4, 1)
As 1 isn't greater than max, so no change in max

Eigth element : 2
As ( 2 - (-2) ) = (4) is present in hashmap, so its length = ( length(4) + 1 ) = ( 1 + 1) = 2
Included in hashmap : (2, 2)
As 2 isn't greater than max, so no change in max

Ninth element : 1
As (1 - (-2) ) = (3) is present in hashmap, so its length = ( length(3) + 1 ) = ( 3 + 1) = 4
Included in hashmap : (1, 4)
As 4 > max : max = 4

After iterating over all numbers, answer is received as max.


# Complexity
- Time complexity:
<!-- Add your time complexity here, e.g. $$O(n)$$ -->

- Space complexity:
<!-- Add your space complexity here, e.g. $$O(n)$$ -->

# Code
```
class Solution {
    public int longestSubsequence(int[] arr, int difference) {

        int max = 0;
        HashMap<Integer, Integer> m = new HashMap<>();
        for( int i : arr){
            m.put(i, m.getOrDefault( i - difference, 0) + 1); // if the previous possible element of the sequence is present already in hashmap then add thats length to the current element length + 1, otherwise 1
            max = Math.max( max, m.get(i)); // updating max value if length is greater than max
        }
        return max;
        
    }
}
```